using System.Globalization;
using TMPro;
using UnityEngine;
using static DataStore;

public class GearDataBinding : MonoBehaviour
{
    private TextMeshPro tmp;
    public string fieldName;
    private AnimData animData;
    private Gear lastValue = Gear.Undefined;
    public string[] gearNames = {"","P","R","N","D","L","1","2","3","4","5","6","7","8"};
    
    private void Start()
    {
        animData = DataStore.GetInstance().GetAnimData(fieldName);
        tmp = GetComponent<TextMeshPro>();
    }
    
    private void Update()
    {
        Gear g = (Gear)DataStore.GetInstance().GetInt(animData);
        if (g != lastValue)
        {
            lastValue = g;
            tmp.text = gearNames[(int)g];
        }
    }
}